# Grid View Configure Plugin Installation

## Introduction

[Restyaboard](https://restya.com/board) is an open source alternative to Trello, but with smart additional features like offline sync, diff /revisions, nested comments, multiple view layouts, chat, and more. And since it is self-hosted, data, privacy, and IP security can be guaranteed.

Restyaboard is more like an electronic sticky note for organizing tasks and todos. Apart from this, it is ideal for Kanban, Agile, Gemba board and business process/workflow management. It can be extended with [productive plugins](https://restya.com/board/apps "productive plugins")

Today, several universities, automobile companies, government organizations, etc from across Europe take advantage of Restyaboard.

This document contains information about how to install and use Grid View Configure app in Restyaboard.

### What you'll learn

*   How to install Grid View Configure app in Restyaboard

## Video Tutorial

For step-by-step instructions on installation and usage of Grid View Configure Plugin Installation in Restyaboard, refer [YouTube video](https://www.youtube.com/watch?v=H-t7hpbDxNM "Watch video on Grid View Configure Plugin Installation in Restyaboard")

[![Grid View Configure Plugin Installation in Restyaboard](gridview-configure-plugin-installation.png)](https://www.youtube.com/watch?v=H-t7hpbDxNM "Watch video on Grid View Configure Plugin Installation in Restyaboard")  

## Grid View Configure Plugin Installation

1.  Download [Grid View Configure App](https://restya.com/board/apps/r_gridview_configure "Grid View Configure App")
2.  Goto Restyaboard installation root directory.e.g., directory: `/usr/share/nginx/html/restyaboard/`
3.  Unzip the purchased Grid View Configure app to your root directory
4.  Open the command prompt in `/usr/share/nginx/html/restyaboard/client/apps/r_gridview_configure/` path and give the executable permission to the shell file `grid_view_configure.sh`.e.g.,`chmod +x grid_view_configure.sh`
5.  Run the shell script file. e.g., `./grid_view_configure.sh`
6.  Clear the browser cache, and login again to view the installed Grid View Configure app on your Restyaboard.