# Gantt View Plugin Installation

## Introduction

[Restyaboard](https://restya.com/board) is an open source alternative to Trello, but with smart additional features like offline sync, diff /revisions, nested comments, multiple view layouts, chat, and more. And since it is self-hosted, data, privacy, and IP security can be guaranteed.

Restyaboard is more like an electronic sticky note for organizing tasks and todos. Apart from this, it is ideal for Kanban, Agile, Gemba board and business process/workflow management. It can be extended with [productive plugins](https://restya.com/board/apps "productive plugins")

Today, several universities, automobile companies, government organizations, etc from across Europe take advantage of Restyaboard.

This document contains information about how to install Gantt View Plugin from admin panel.

### What you'll learn

*   How to install the Gantt View plugin in the Restyaboard

## Video Tutorial

For step-by-step instructions on Gantt View Plugin Installation, refer [YouTube video](https://www.youtube.com/watch?v=4UYtTWpGhj8 "Watch video on Gantt View Plugin Installation")

[![Gantt View Plugin Installation](gantt_view_installation.png "Gantt View Plugin Installation")](http://www.youtube.com/watch?v=4UYtTWpGhj8 "Watch video on Gantt View Plugin Installation")

## Gantt View Plugin Installation

1.  Download [Gantt View app](https://restya.com/board/apps/r_gantt_view "Gantt View app")
2.  Goto your Restyaboard installation root directory. e.g., directory: `/usr/share/nginx/html/restyaboard/`
3.  Extract/unzip the downloaded plugin zip into the restyaboard installation path. e.g., `/usr/share/nginx/html/restyaboard/`
4.  Give file permission to extracted files. e.g., `chmod -R 0777 client/apps/r_gantt_view/`
5.  After the above process, clear the browser cache and login again to view the installed Gantt View plugin on your Restyaboard.