// http://nshipster.com/method-swizzling/
// HTMLElement Swizzle - To swizzle a method is to change a class’s dispatch table in order to resolve messages from an existing selector to a different implementation, while aliasing the original method implementation to a new selector.

// 3.2.3 HTML element constructors
// https://html.spec.whatwg.org/multipage/dom.html#html-element-constructors
// Satisfy Element interface document.createElement
//   - https://dom.spec.whatwg.org/#concept-element-interface


//// base class to extend, same trick as before
//class HTMLCustomElement extends HTMLElement {

//  constructor(_)
//    { return (_ = super(_)).init(), _; }

//  init()
//    { /* override as you like */ }
//}

var HTMLElement = function(t) {
        function e() {}
        return e.prototype = window.HTMLElement.prototype, e
    }(),
    TokenList = function(t) {
        for (var e = this, n = function(t) {
                return /{(\w+|#)}/.test(t.textContent) && (t.text = t.textContent).match(/[^{]+(?=})/g).map(function(n) {
                    return (e[n] || (e[n] = [])).push(t)
                })
            }, o = document.createNodeIterator(t, NodeFilter.SHOW_ELEMENT | NodeFilter.SHOW_TEXT, function(t) {
                return t.attributes && [].slice.call(t.attributes).map(n) || n(t)
            }, null); o.nextNode(););
    };
TokenList.prototype.bind = function(t) {
        var e = function(e) {
            return function(n) {
                return n.textContent = n.textContent.split("{" + e + "}").join(t[e])
            }
        };
        for (var n in this) "bind" != n && this[n].map(function(t) {
            return (t.textContent = t.text) && t
        });
        for (var o in this) "bind" != o && this[o].map(e(o))
    },
    function(t) {
        function e(t) {
            var e = new XMLHttpRequest;
            e.link = t, e.onload = n, e.open("GET", t.href), e.responseType = "document", e.send()
        }

        function n() {
            for (var t = this.link, e = this.response, n = t.nextChild, i = t.content = e.querySelector("template"), c = 0, l = document.querySelectorAll(t.id); c < l.length; c += 1) {
                var s = l[c];
                i && r.call(s, i)
            }
            for (var a = 0, u = e.querySelectorAll("style,link,script"); a < u.length; a += 1) {
                o(t, u[a], n)
            }
        }

        function o(t, e, n) {
            var o = e.getAttribute("as"),
                r = document.createElement("script" == o ? o : e.localName);
            ["id", "rel", "href", "src", "textContent", "as", "defer", "crossOrigin"].map(function(t) {
                return e[t] && t in r && (r[t] = e[t])
            }), "style" == o && (r.rel = "stylesheet"), "script" == o && (r.src = r.href), t.parentNode.insertBefore(r, n)
        }

        function r(t) {
            var e, n = this;
            t = document.importNode(t, !0), [].slice.call(t.attributes).map(function(t) {
                return !n.attributes[t.name] && n.setAttribute(t.name, t.value)
            });
            for (var o = 0, r = this.querySelectorAll("[slot]"); o < r.length; o += 1) {
                var i = r[o];
                (e = (t.content || t).querySelector("slot[name=" + i.getAttribute("slot") + "]")) && e.parentNode.replaceChild(i, e)
            }
            return this.innerHTML = t.innerHTML
        }
        new MutationObserver(function(t) {
            for (var n = 0, o = t; n < o.length; n += 1)
                for (var i = 0, c = o[n].addedNodes; i < c.length; i += 1) {
                    var l = c[i];
                    /^p/.test(l.rel) && /\-/.test(l.id) && e(l), /\-/.test(l.localName) && (link = document.querySelector("#" + l.localName)) && link.content && r.call(l, link.content) && customElements.upgrade(l)
                }
        }).observe(document.documentElement, {
            childList: !0,
            subtree: !0
        }), [].slice.call(document.querySelectorAll('[rel^=pre][id~="-"]')).map(e)
    }();
var Template = function(t) {
    var e = document.createRange();
    t = "string" == typeof t ? document.querySelector("template[name=" + t + "]") : t, e.selectNodeContents(t.content);
    var n = e.cloneContents();

    function o(t, e) {
        var o = n.cloneNode(!0);
        return "object" != typeof t && (t = {
            self: t
        }), t["#"] = e, new TokenList(o).bind(t), o
    }
    return t.bind = function(n) {
        e.setStartAfter(t), e.deleteContents(), n && [].concat(n).map(o).reverse().map(function(t) {
            return e.insertNode(t)
        })
    }, t
};
window.customElements = window.customElements || {}, customElements.define = function(t, e) {
    /\-/.test(t) && (customElements[t] = e) && [].slice.call(document.querySelectorAll(t)).map(customElements.upgrade)
}, customElements.upgrade = function(t) {
    Object.setPrototypeOf(t, customElements[t.localName].prototype), 'undefined' !== t && t.connectedCallback()
}, new MutationObserver(function(t) {
    for (var e = 0, n = t; e < n.length; e += 1)
        for (var o = 0, r = n[e].addedNodes; o < r.length; o += 1) {
            var i = r[o];
            /\-/.test(i.localName) && customElements[i.localName] && customElements.upgrade(i)
        }
}).observe(document.documentElement, {
    childList: !0,
    subtree: !0
});
var ParentNode = function(t) {
        return function(t) {
            function e() {
                t.apply(this, arguments)
            }
            return t && (e.__proto__ = t), e.prototype = Object.create(t && t.prototype), e.prototype.constructor = e, e.prototype.select = function() {
                var t;
                return (t = this).selectAll.apply(t, arguments)[0]
            }, e.prototype.selectAll = function(t) {
                for (var e = [], n = arguments.length - 1; n-- > 0;) e[n] = arguments[n + 1];
                return t = [].concat(t), [].slice.call(this.querySelectorAll(e.reduce(function(e, n) {
                    return e + n + t.shift()
                }, t.shift())))
            }, e
        }(t)
    },
    EventTarget = function(t) {
        return function(t) {
            function e() {
                t.apply(this, arguments)
            }
            return t && (e.__proto__ = t), e.prototype = Object.create(t && t.prototype), e.prototype.constructor = e, e.prototype.on = function(t, e) {
                this.addEventListener(t, this.renderable(e))
            }, e.prototype.renderable = function(t) {
                var e = this;
                return function(n) {
                    return !1 !== t.call(e, n) && n.defaultPrevented || e.render()
                }
            }, e.prototype.reflect = function(e) {
                /^on/.test(e) && e in t.prototype && this.on(e.substr(2), this[e])
            }, e.prototype.register = function(t, e, n) {
                for (var o = 0, r = [].slice.call(t.attributes); o < r.length; o += 1) {
                    var i = r[o];
                    /^on/.test(n = i.name) && (e = (/{\s*(\w+)/.exec(t[n]) || [])[1]) && (t[n] = this.renderable(this[e]))
                }
            }, e
        }(t)
    },
    GlobalEventHandlers = function(t) {
        return function(t) {
            function e() {
                t.apply(this, arguments)
            }
            return t && (e.__proto__ = t), e.prototype = Object.create(t && t.prototype), e.prototype.constructor = e, e.prototype.onconnect = function(e) {
                this.templates = this.selectAll("template[name]").map(Template), this.tokens = new TokenList(this), t.prototype.onconnect && t.prototype.onconnect.call(this, e)
            }, e
        }(t)
    },
    Custom = function(t) {
        return function(e) {
            function n() {
                e.apply(this, arguments)
            }
            return e && (n.__proto__ = e), n.prototype = Object.create(e && e.prototype), n.prototype.constructor = n, n.prototype.connectedCallback = function() {
                this.context = {}, e.prototype.initialize && e.prototype.initialize.call(this), Object.getOwnPropertyNames(t.prototype).map(this.reflect, this), this.addEventListener("connect", this.onconnect), this.addEventListener.call(this, "idle", e.prototype.onidle), this.dispatchEvent(new Event("connect")), this.render()
            }, n.prototype.upgrade = function() {}, n.prototype.render = function() {
                for (var t = 0, e = this.templates; t < e.length; t += 1) {
                    var n = e[t];
                    n.bind(this[n.getAttribute("name")])
                }
                this.tokens.bind(this), this.register(this), this.selectAll("*").map(this.register, this), this.dispatchEvent(new Event("idle"))
            }, n
        }(ParentNode(EventTarget(GlobalEventHandlers(t))))
    },
    Element = function(t) {
        return function(e) {
            return customElements.define(t + "", Custom(e))
        }
    };