### Restyaboard

[![Build Status](https://travis-ci.org/RestyaPlatform/board.svg?branch=master)](https://travis-ci.org/RestyaPlatform/board) [![Average time to resolve an issue](http://isitmaintained.com/badge/resolution/RestyaPlatform/board.svg)](http://isitmaintained.com/project/RestyaPlatform/board "Average time to resolve an issue") [![Percentage of issues still open](http://isitmaintained.com/badge/open/RestyaPlatform/board.svg)](http://isitmaintained.com/project/RestyaPlatform/board "Percentage of issues still open")
[![Known Vulnerabilities](https://snyk.io/test/github/RestyaPlatform/board/badge.svg)](https://snyk.io/test/github/RestyaPlatform/board)

### What is Restyaboard?
Trello like kanban board. Tasks, to-dos, chat, etc., [Restyaboard](http://restya.com/board/) is based on [Restya platform](http://restya.com/) with dual License ([OSL 3.0](LICENSE.txt) & [Commercial License](http://restya.com/contact)).

Whether you’re creating a personal todo list, planning your holidays with some friends, or working in a team on your next revolutionary concept, Restyaboard is an simple and effective tool to keep your tasks organized. The boards of restyaboard will give you a visual overview of the current state of your projects, and make you productive by allowing you to focus on the few items that matter the most.

### Why use Restyaboard?
Since Restyaboard is free software, you don’t have to give us your data and you can install the Restyaboard on your own internal server. You can also increase your productivity even more by reducing the time of managing the projects with the help of the Restyaboard plugin which is available in [RestyaPlatform](http://restya.com/board/apps).

# For Free Installation, [contact us](http://restya.com/contact?category=free-installation) 

### Status: Active

* Project is active! Follow development in [dev](https://github.com/RestyaPlatform/board/tree/dev) branch
* Upcoming [milestone](https://github.com/RestyaPlatform/board/milestones)

### Demo

[Demo](http://restya.com/board/demo)

### Install

* [Install](http://restya.com/board/install)
* [Configure](http://restya.com/board/install#configure)
* [Importing from trello](http://restya.com/board/install#import-trello)

### Upgrade

To upgrade, overwrite application files and apply respective DB script:

*  v0.1.1 to v0.1.2 - [`/sql/upgrade-0.1.1-0.1.2.sql`](https://github.com/RestyaPlatform/board/blob/master/sql/upgrade-0.1.1-0.1.2.sql)
*  v0.1.2 to v0.1.3 - [`/sql/upgrade-0.1.2-0.1.3.sql`](https://github.com/RestyaPlatform/board/blob/master/sql/upgrade-0.1.2-0.1.3.sql)
*  v0.1.3 to v0.1.4 - [`/sql/upgrade-0.1.3-0.1.4.sql`](https://github.com/RestyaPlatform/board/blob/master/sql/upgrade-0.1.3-0.1.4.sql)
*  v0.1.4 to v0.1.5 - [`/sql/upgrade-0.1.4-0.1.5.sql`](https://github.com/RestyaPlatform/board/blob/master/sql/upgrade-0.1.1-4.1.5.sql)
*  v0.1.5 to v0.1.6 - [`/sql/upgrade-0.1.5-0.1.6.sql`](https://github.com/RestyaPlatform/board/blob/master/sql/upgrade-0.1.5-0.1.6.sql)
*  v0.1.6 to v0.2 - [`/sql/upgrade-0.1.6-0.2.sql`](https://github.com/RestyaPlatform/board/blob/master/sql/upgrade-0.1.6-0.2.sql)
*  v0.2 to v0.2.1 - [`/sql/upgrade-0.2-0.2.1.sql`](https://github.com/RestyaPlatform/board/blob/master/sql/upgrade-0.2-0.2.1.sql)
*  v0.2.1 to v0.3 - [`/sql/upgrade-0.2.1-0.3.sql`](https://github.com/RestyaPlatform/board/blob/master/sql/upgrade-0.2.1-0.3.sql)
*  v0.3 to v0.4 - [`/sql/upgrade-0.3-0.4.sql`](https://github.com/RestyaPlatform/board/blob/master/sql/upgrade-0.3-0.4.sql)
*  v0.4 to v0.4.1 - [`/sql/upgrade-0.4-0.4.1.sql`](https://github.com/RestyaPlatform/board/blob/master/sql/upgrade-0.4-0.4.1.sql)
*  v0.4.2 to v0.5 - [`/sql/upgrade-0.4.2-0.5.sql`](https://github.com/RestyaPlatform/board/blob/master/sql/upgrade-0.4.2-0.5.sql)
*  v0.5.1 to v0.5.2 - [`/sql/upgrade-0.5.1-0.5.2.sql`](https://github.com/RestyaPlatform/board/blob/master/sql/upgrade-0.5.1-0.5.2.sql)
*  v0.5.2 to v0.6 - [`/sql/upgrade-0.5.2-0.6.sql`](https://github.com/RestyaPlatform/board/blob/master/sql/upgrade-0.5.2-0.6.sql)
*  v0.6 to v0.6.1 - [`/sql/upgrade-0.6-0.6.1.sql`](https://github.com/RestyaPlatform/board/blob/master/sql/upgrade-0.6-0.6.1.sql)
*  v0.6.1 to v0.6.2 - [`/sql/upgrade-0.6.1-0.6.2.sql`](https://github.com/RestyaPlatform/board/blob/master/sql/upgrade-0.6.1-0.6.2.sql)
*  v0.6.2 to v0.6.3 - [`/sql/upgrade-0.6.2-0.6.3.sql`](https://github.com/RestyaPlatform/board/blob/master/sql/upgrade-0.6.2-0.6.3.sql)
*  v0.6.3 to v0.6.4 - [`/sql/upgrade-0.6.3-0.6.4.sql`](https://github.com/RestyaPlatform/board/blob/master/sql/upgrade-0.6.3-0.6.4.sql)
*  v0.6.5 to v0.6.6 - [`/sql/upgrade-0.6.5-0.6.6.sql`](https://github.com/RestyaPlatform/board/blob/master/sql/upgrade-0.6.5-0.6.6.sql)
*  v0.6.6 to v0.6.7 - [`/sql/upgrade-0.6.6-0.6.7.sql`](https://github.com/RestyaPlatform/board/blob/master/sql/upgrade-0.6.6-0.6.7.sql)
*  v0.6.7 to v0.6.8 - [`/sql/upgrade-0.6.7-0.6.8.sql`](https://github.com/RestyaPlatform/board/blob/master/sql/upgrade-0.6.7-0.6.8.sql)
*  v0.6.8 to v0.6.9 - [`/sql/upgrade-0.6.8-0.6.9.sql`](https://github.com/RestyaPlatform/board/blob/master/sql/upgrade-0.6.8-0.6.9.sql)
*  v0.6.9 to v1.7 - [`/sql/upgrade-0.6.9-1.7.sql`](https://github.com/RestyaPlatform/board/blob/master/sql/upgrade-0.6.9-1.7.sql)

### To upgrade in linux run the following commands. Overwrite All, when prompted by script:
sudo wget https://github.com/RestyaPlatform/board/raw/master/restyaboard.sh –no-check-certificate
sudo ./restyaboard.sh

### Configuring Restyaboard

* Login using username `admin`, password `restya`
* If installed via Amazon AMI, then login using the username `admin` and the `instance_id` of the instance as the password
* Visit admin panel at `/#/settings/6`
* Update Dropbox App Key by visiting [https://www.dropbox.com/developers/apps/](https://www.dropbox.com/developers/apps/)
* Update Flickr API Key by visiting [https://www.flickr.com/services/apps/](https://www.flickr.com/services/apps/)
* Update Unsplash API Key by visiting [https://unsplash.com/developers](https://unsplash.com/developers)
* Visit `/#/settings/3` for configuring site name, email and server timezone.
* Change admin email and password
* To add/reply cards via email, visit `/#/settings/10` to configure IMAP settings

### Forum

* [Restya Google Group](https://groups.google.com/d/forum/restya)


### Docker configuration

In the container you can set following variables:

| Variable            | Description                                                                  | Default       |
| ------------------- | ---------------------------------------------------------------------------- | ------------- |
| POSTGRES_HOST       | The host address of postgres.                                                | `postgres`    |
| POSTGRES_PORT       | The port of the postgres host.                                               | `5432`        |
| POSTGRES_ADMIN_USER | An admin user in postgres. (Needed for creating restya user and extensions.) |               |
| POSTGRES_ADMIN_PASS | The password of the admin postgres user.                                     |               |
| RESTYA_DB_USERNAME  | The desired restya db user which has access to the restya database.          |               |
| RESTYA_DB_USERPASS  | The restya db user password.                                                 |               |
| RESTYA_DB           | Name of the database for restya.                                             | `restyaboard` |
| SMTP_SERVER         | Address of the SMTP server.                                                  | `smtp_relay`  |
| SMTP_PORT           | Port of the SMTP server.                                                     | `587`         |
| TZ                  | Used timezone inside container.                                              | `Etc/UTC`     |


#### Database

The docker container creates necessary restyaboard user and relations in postgres during startup.
Therefore it checks if the `RESTYA_DB` database already exists.
If it exists it skips the init step for database.

This means if you setup the database on your own you have also to make sure that all relations and users will be added.

------------

### Current Status / Plans / Roadmap

To give you some idea about of our plans:

#### Under release

* Sandstorm support for Installation
* In notification emails, Gmail Action Button "View on Restyaboard"
* GitHub issues & enhancements etc.,

#### Next

* Undisclosed domain centric plugins
* Marketplace for ecosystem
  * Allow developers to make money
* Apps listing platform
  * Find apps easily

------------

### FAQ (Frequently Asked Questions)

#### Do you have any installation instructions for Windows?

Please find in [Restyaboard Install in Windows](http://restya.com/board/docs/windows) document. If you face any issue, please feel free to [open a ticket](https://github.com/RestyaPlatform/board/issues/new)

#### Do you have any installation instructions for Apache?

Please check [Restyaboard Install in Apache](http://restya.com/board/docs/apache)

#### Getting blank page after install

Most likely it is related to your DB credentials. Please check the install log and see if your setup was complete without any errors.

#### How can I contribute to Restyaboard translation?

Please translate Restyaboard via [transifex](https://www.transifex.com/restya/restyaboard/)

------------

### Contributing

Our approach is similar to Magento. If anything is not clear, please [contact us](http://restya.com/contact?category=contributing).

All Submissions you make to Restya through GitHub are subject to the following terms and conditions:

* You grant Restya a perpetual, worldwide, non-exclusive, no charge, royalty free, irrevocable license under your applicable copyrights and patents to reproduce, prepare derivative works of, display, publicly perform, sublicense and distribute any feedback, ideas, code, or other information ("Submission") you submit through GitHub.
* Your Submission is an original work of authorship and you are the owner or are legally entitled to grant the license stated above.


### Build

Required sofware: nginx, php-fpm (with mbstring), PostgreSQL, ElasticSearch, Grunt

* `grunt less` - Converts LESS to CSS
* `grunt jst` - Converts EJS to JS
* `grunt watch` - Converts LESS to CSS and EJS to JS, automatically by "watching" for file changes
* `restyaboard_with_empty_data.sql` - Database generation script 
* `server/php/config.inc.php` - Database and other configurations
* `media`, `client/img`, `tmp/cache` & `server/php/shell/*.sh` - Need write permission for php; can be `chmod 655` or `755` or `777` depending upon server configuration
* `grunt build:live` - Generates restyaboard.zip, deployable code. Replace your DB details in `build/live.json`.

------------

### License

Copyright (c) 2014-2019 [Restya](http://restya.com/).

Dual License ([OSL 3.0](LICENSE.txt) & [Commercial License](http://restya.com/contact))
